require( "scripts/style.lua" );

local hs_closed = false;
standardFont = edwardian_medium;

HeaderFont = {
  standardFont,
  45,
  WhiteColor
};


GameModeFont = {
  standardFont,
  30,
  WhiteColor
};

TableInfoFont = {
  standardFont,
  30,
  WhiteColor
};

EligibleAsteriskFont = {
  standardFont,
  12,
  WhiteColor
};

ConnectingToServerFont = {
	standardFont,
	18,
	WhiteColor
};

TableHeaderFont = {
  standardFont,
  20,
  WhiteColor
};

ScoreInfoFont = {
  standardFont,
  18,
  WhiteColor
};


ScoreFont = {
  standardFont,
  18,
  WhiteColor
};

LeftButtonGraphics = {
	"ui/buttons/arrowleft_up",
	"ui/buttons/arrowleft_down",
	"ui/buttons/arrowleft_over"
};

kScoreRowSpace = 21;
kRowY = 56;
kNumberX = 35;
kP1X = kNumberX + 1;
kNameX = kP1X + 15;
kScoreX = kNameX + 234;

kNameW = 175
kNameH = 21

eLocalView=0;
eRequestingCategories=1;
eRequestingScores=2;
eSubmitting=3;
eGlobalView=4;
eError=5;

function UpdateButtons()
	local state = GetState();
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	EnableWindow("view",false);
	EnableWindow("viewlocal",false);
	EnableWindow("submit",false);
	EnableWindow("categoryleft",false);
	EnableWindow("categoryright",false);
	
	if (state==eLocalView) then
		local eligibleScore;

		if fullHS then
			EnableWindow("moreinfo",true);
		else 
			EnableWindow("moreinfo",false);
		end
		
		if not localHS then
			EnableWindow("view",true);

			if (ScoreAvailable()) then
				EnableWindow("submit",true);
			end
		end
	elseif (state == eGlobalView) then
		EnableWindow("viewlocal",true);
		EnableWindow("categoryleft",true);
		EnableWindow("categoryright",true);
	elseif (state == eError) then
		EnableWindow("viewlocal",true);
	end

end


MakeDialog
{
	-- Name the modal dialog
	name="hiscorescreen",
	Bitmap
	{
		image="ui/backgrounds/cs_background",
        
        Bitmap{
            image = "ui/hiscores/b_icon",
            x = kCenter,
            y = 5
        },
		HiscoreWindow
		{
			x=0,y=0,h=kMax,w=kMax,

			Text
			{
				font = HeaderFont,
				name = "header",
				x=0,y=90,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "#<outline color='000000' size='2'>"..GetString( 'scores_header' ).."</outline>"
			};

			Text
			{
				font = GameModeFont,
				name = "gamemode",
				x=0,y=138,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "#GAMEMODE"
			};
			
			Button
			{
				graphics = LeftButtonGraphics,
				name="gamemodeleft",
				x=210,
				y=135,
				scale = 0.65
			};

			Button
			{
				graphics = LeftButtonGraphics,
				name="gamemoderight",
				x=540,
				y=135,
				hflip=true,
				scale = 0.65
			};

			Bitmap
			{
				x = 122,
				y = 175,
				image = "ui/hiscores/global-hs-bb_large",
				name="leftpanel",

				Text
				{
					font = TableHeaderFont,
					name = "local",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_localhs"
				};

				Text
				{
					font = TableHeaderFont,
					name = "global",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_globalhs"
				};

				Text
				{
					font = TableHeaderFont,
					name = "topplayers",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_topplayers"
				};
			
				Button
				{
					graphics = LeftButtonGraphics,
					name="categoryleft",
					x=50,
					y=30,
					scale = 0.45
				};
				
				Text
				{
					font = ScoreFont,
					name = "category",
					x=0,y=35,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
				};

				Button
				{
					graphics = LeftButtonGraphics,
					name="categoryright",
					x=227,
					y=30,
					scale = 0.45,
					hflip=true,
				};

				Text
				{
					font = ScoreFont,
					name = "1",
					x=0,y=kRowY,w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "1."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_1",
					x=kP1X,y=kRowY
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name1",
					x=kNameX,y=kRowY,w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score1",
					x=0,y=kRowY,w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "2",
					x=0,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "2."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_2",
					x=kP1X,y=kRowY+(1*kScoreRowSpace)
				};


				RShrinkText
				{
					font = ScoreFont,
					name = "name2",
					x=kNameX,y=kRowY+(1*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score2",
					x=0,y=kRowY+(1*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "3",
					x=0,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "3."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_3",
					x=kP1X,y=kRowY+(2*kScoreRowSpace)
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name3",
					x=kNameX,y=kRowY+(2*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score3",
					x=0,y=kRowY+(2*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "4",
					x=0,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "4."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_4",
					x=kP1X,y=kRowY+(3*kScoreRowSpace)
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name4",
					x=kNameX,y=kRowY+(3*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score4",
					x=0,y=kRowY+(3*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "5",
					x=0,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "5."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_5",
					x=kP1X,y=kRowY+(4*kScoreRowSpace)
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name5",
					x=kNameX,y=kRowY+(4*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score5",
					x=0,y=kRowY+(4*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "6",
					x=0,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "6."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_6",
					x=kP1X,y=kRowY+(5*kScoreRowSpace)
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name6",
					x=kNameX,y=kRowY+(5*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score6",
					x=0,y=kRowY+(5*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "7",
					x=0,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "7."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_7",
					x=kP1X,y=kRowY+(6*kScoreRowSpace)
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name7",
					x=kNameX,y=kRowY+(6*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score7",
					x=0,y=kRowY+(6*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "8",
					x=0,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "8."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_8",
					x=kP1X,y=kRowY+(7*kScoreRowSpace)
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name8",
					x=kNameX,y=kRowY+(7*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score8",
					x=0,y=kRowY+(7*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "9",
					x=0,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "9."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_9",
					x=kP1X,y=kRowY+(8*kScoreRowSpace)
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name9",
					x=kNameX,y=kRowY+(8*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score9",
					x=0,y=kRowY+(8*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

				Text
				{
					font = ScoreFont,
					name = "10",
					x=0,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "10."
				};

				Bitmap
				{
					image = "ui/hiscores/p1icon",
					name = "p1_10",
					x=kP1X,y=kRowY+(9*kScoreRowSpace)
				};

				RShrinkText
				{
					font = ScoreFont,
					name = "name10",
					x=kNameX,y=kRowY+(9*kScoreRowSpace),w=kNameW,h=kNameH,
					flags = kHAlignLeft + kVAlignCenter,
					label = "#name"
				};

				Text
				{
					font = ScoreFont,
					name = "score10",
					x=0,y=kRowY+(9*kScoreRowSpace),w=kScoreX,h=kMax,
					flags = kHAlignRight + kVAlignTop,
					label = "12345"
				};

			};

			Bitmap
			{
				x = 450,
				y = 175,
				image="ui/hiscores/local-hs-bb",
				name="rightpanelsmall",

				Text
				{
					font = ScoreInfoFont,
					name = "yourrankglobalinfo",
					x=20,y=45,w=kMax-20,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_globalhighscoreinfo"
				};

				Text
				{
					font = TableHeaderFont,
					name = "yourrank",
					x=10,y=10,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_yourrank"
				};

				Text
				{
					font = TableHeaderFont,
					name = "congratulations",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_congrats"
				};

				Text
				{
					font = TableHeaderFont,
					name = "dnq",
					x=10,y=50,w=kMax-10,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_dnq"
				};
			},


			Bitmap
			{
				x = 450,
				y = 175,
				image="ui/hiscores/local-hs-bb",
				name="rightpanel",

				Text
				{
					font = TableHeaderFont,
					name = "globalinfoheader",
					x=0,y=10,w=kMax,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_globalhs"
				};

				Text
				{
					font = ScoreInfoFont,
					name = "info",
					x=20,y=45,w=kMax-20,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_globalhighscoreinfo"
				};


				Text
				{
					font = ScoreInfoFont,
					name = "eligible",
					x=20,y=150,w=kMax-20,h=kMax,
					flags = kHAlignCenter + kVAlignTop,
					label = "scores_eligible"
				};

				SetStyle(CSOvalLightBlueButtonStyle),
				Button
				{
					x=kCenter - 46,
					y=kMax-70,
					name="moreinfo",
					label="scores_moreinfo",
					command =
						function()
							DoModal("scripts/hiscoreinfo.lua");
						end

				};

				SetStyle(CSOvalGreenButtonStyle),
				Button
				{
					x=kCenter + 46,
					y=kMax-70,
					name="submit",
					label="scores_submit",
				};
			};

			Text
			{
				font = ConnectingToServerFont,
				name = "server",
				x=465,y=175,w=196,h=270,
				flags = kHAlignCenter + kVAlignBottom,
				label = "scores_connecting"
			};

			Text
			{
				font = ConnectingToServerFont,
				name = "error",
				x=465,y=175,w=196,h=270,
				flags = kHAlignCenter + kVAlignBottom,
			};

			Button
			{
				graphics = LeftButtonGraphics,
				rotate=true,
				name="scrollup",
				x=411,
				y=192,
				scale = 0.4
			};

			Button
			{
				graphics = LeftButtonGraphics,
				rotate=true,
				hflip=true,
				name="scrolldown",
				x=411,
				y=407,
				scale = 0.4
			};
			
			---------------------------------------------- Back
			SetStyle(CSMMRight1ButtonStyle),
			Button
			{
				x = 219, y = 475,
				name = "back",
				hflip = true,
				Text {
					font = CSMainMenuFont,
					x = 25, y = 0,
					w = kMax - 20, h = kMax - 15,
					flags = kHAlignCenter + kVAlignCenter,
					label = "app_back"
				},
				command =
					function()
					    --if( not hs_closed ) then
					        --hs_closed = true;
					        DoTransition( kFadeToBlack );
					        PopModal( 'hiscorescreen' );
						--end
					end
			},
			
			---------------------------------------------- View Global
			SetStyle(CSMMRight1ButtonStyle),
			Button
			{
				x = 452, y = 474,
				name = "view",
				Text {
					font	= CSMainMenuFont,
					x = 25, y = 8,
					w = kMax - 30, h = kMax - 15,
					flags	= kHAlignCenter + kVAlignCenter,
					label	= "scores_viewglobal",
					name = "view_text"
				},
			},
			
			---------------------------------------------- View Local
			Button
			{
				x = 452, y = 474,
				name = "viewlocal",
				Text {
					font	= CSMainMenuFont,
					x = 25, y = 8,
					w = kMax - 30, h = kMax - 15,
					flags	= kHAlignCenter + kVAlignCenter,
					label	= "scores_viewlocal",
					name = "viewlocal_text"
				},
			},
		},
	},
}

PostMessage( CreateNamedMessage( kFadeFromBlack ) );